/*	copy.c	1.8	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

#define	CTRL_Z	0x1a		/* CP/M end-of-file */


/************************************************************************
 * NAME:	copytext()
 *
 * DESCR:	Used by cpm_copyout(), copies either a binary or a text
 *		file from CPM to the local filesystem.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
static void
copytext(C_FILE *cid, FILE *ufid)
{
    int c = 0;

    while (((c = c_getc(cid)) != EOF) && (c != CTRL_Z)) {
	if ( c != '\r') 
	    putc(c, ufid);
    }
    if (isatty(fileno(ufid))) 
	printf("\n");
    else
	fclose(ufid);
}

static void
copybin(C_FILE *cid, FILE *ufid)
{
    int c = 0;

    while ((c = c_getc(cid)) != EOF) 
	putc(c, ufid);
    fclose(ufid);
}

/************************************************************************
 * NAME:	cpm_copyout()
 *
 * DESCR:	Copies a CPM file to the local filesystem.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if things went OK, FALSE otherwise.
 *
 * NOTES:	
 ************************************************************************/
int
cpm_copyout(struct cpmfs *cpmfs, char cpmfile[], char unixfile[], int bin)
{
	FILE *ufid;
	char name[9], ext[4];
	C_FILE *cid;

	if (!(cpm_namesep(cpmfile, name, ext))) {
	    return(FALSE);
	}
	if ((cid = cpm_file_open(cpmfs, name, ext, READ)) == NULL) {
	    return(FALSE);
	}
	if (access(unixfile,0) == 0) {
	    return(FALSE);
	}
	if ((ufid = fopen(unixfile, "w")) == NULL) {
	    return(FALSE);
	}

	if (bin) {
	    copybin(cid, ufid);
	} else {
	    copytext(cid, ufid);
	}
	cpm_file_close(cid);

	return(TRUE);
}
